﻿define(['durandal/system', 'plugins/router', 'durandal/app', 'services/datacontext', 'config', 'services/logger', 'knockout', 'services/appsecurity','services/knockout-authenticate'],
    function (system, router, app, datacontext, config, logger, ko, appsecurity) {
        // Set authenticate config
        ko.authenticate.config(config.authenticate);

        var shell = {
            router: router,
            search: function () {
                //It's really easy to show a message box.
                //You can add custom options too. Also, it returns a promise for the user's response.
                app.showMessage('Search not yet implemented...');
            },
            isLoggedIn: appsecurity.userInfo,
            activate: activate,
            logout: function(){
                appsecurity.logout();
                appsecurity.clearAuthInfo();
                router.navigate("account/login");
            }
        };

        return shell;

        //#region Internal Methods
        function activate() {
            return datacontext.primeData()
                .then(boot)
                .fail(failedInitialization);
        }

        function boot() {
//            router.activeItem.subscribe(function( val ) {
//                debugger;
//
//            });
//
//            if(!shell.canAccess()){
////                alert(1);
//                setTimeout(function(){
//                    router.navigate('#');
//                }, 500)
//            }
            log('Oil Database loaded!', null, true);

            //configure routing
            router.makeRelative({ moduleId: 'viewmodels' });

            // If the route has the authorize flag and the user is not logged in => navigate to login view
            router.guardRoute = function (instance, instruction) {
                if (sessionStorage["redirectTo"]) {
                    var redirectTo = sessionStorage["redirectTo"]
                    sessionStorage.removeItem("redirectTo");
                    return redirectTo;
                }

                if (instruction.config.authorize) {
                    if (typeof (appsecurity.userInfo()) !== 'undefined') {
                        if (appsecurity.isUserInRole(instruction.config.authorize)) {
                            return true;
                        } else {
                            return "/account/login?returnUrl=" + encodeURIComponent(instruction.fragment);
                        }
                    } else {
                        return "/account/login?returnUrl=" + encodeURIComponent(instruction.fragment);
                    }
                } else {
                    return true;
                }
            };

            router.map(config.routes).buildNavigationModel();

            return router.activate();
        }

        function failedInitialization(error) {
            var msg = 'App initialization failed: ' + error.message;
            logger.logError(msg, error, system.getModuleId(shell), true);
        }

        function log(msg, data, showToast) {
            logger.log(msg, data, system.getModuleId(shell), showToast);
        }
});