﻿requirejs.config({
    paths: {
        'text': '../lib/require/text',
        'durandal':'../lib/durandal/js',
        'plugins' : '../lib/durandal/js/plugins',
        'transitions' : '../lib/durandal/js/transitions',
        'knockout': '../lib/knockout/knockout-3.1.0',
        'knockout-validation': '../lib/knockout-validation/Dist/knockout.validation.min',
        'bootstrap': '../lib/bootstrap/js/bootstrap.min',
        'jquery': '../lib/jquery/jquery-1.9.1.min',
        'x-editable': '../lib/x-editable/dist/bootstrap3-editable/js/bootstrap-editable.min',
        'knockout-editable': '../lib/knockout-x-editable/knockout.x-editable.min',
        'select2': '../lib/select2/select2.min',
        'Q': '../lib/q/q',
        'breeze': '../lib/breezejs/breeze.min',
        'breeze-labs': '../lib/breezejs/labs',
        'breeze-adapters': '../lib/breezejs/adapters'
    },
    shim: {
        'bootstrap': {
            deps: ['jquery'],
            exports: 'jQuery'
       },
        'breeze': {
            deps: ['Q'],
            exports: 'Q'
        },
        'knockout-editable': {
            deps: ['bootstrap', 'x-editable'],
            exports: '$'
        }
    },
    waitSeconds: 0
});

define(['durandal/system', 'durandal/app', 'durandal/viewLocator', 'services/appsecurity', 'knockout', 'knockout-validation', 'bootstrap'],  function (system, app, viewLocator, appsecurity, ko) {
    //>>excludeStart("build", true);
    system.debug(true);
    //>>excludeEnd("build");

    app.title = 'Oils Database';

    app.configurePlugins({
        observable: true,
        router:true,
        dialog: true,
        widget: {
           // kinds: ['grid']
        }
    });

    app.start().then(function() {
        //Replace 'viewmodels' in the moduleId with 'views' to locate the view.
        //Look for partial views in a 'views' folder in the root.
        viewLocator.useConvention();

        // Configure ko validation
        ko.validation.init({
            decorateElement: true,
            errorElementClass: "has-error",
            registerExtenders: true,
            messagesOnModified: true,
            insertMessages: true,
            parseInputAttributes: true,
            messageTemplate: null
        });

        //Show the app by setting the root view model for our application with a transition.
        //Show the app by setting the root view model for our application with a transition.
        appsecurity.initializeAuth()
            .then(function (data) {
                app.setRoot('viewmodels/shell');
            });
    });
});