define(['knockout'], function (ko) {
    toastr.options.timeOut = 4000;
    toastr.options.positionClass = 'toast-bottom-right';

    var imageSettings = {
        imageBasePath: '../content/images/photos/',
        unknownPersonImageSource: 'unknown_person.jpg'
    };
    
    var remoteServiceName = 'https://oil.syncrolife.ru/api/index.php';
    
    var storage = {
        enabled: false, //TODO: toggle this to use Local Storage
        key: 'Oil_Database'
    };
    var routes = [
        { route: '', title: 'Home', moduleId: 'home/welcome', nav: true , authorize: ["User", "Administrator"] },
        { route: 'healths', title: 'Healths', moduleId: 'health/healths', nav: true , authorize: ["User", "Administrator"] },
        { route: 'health/:id', title: 'Health Detail', moduleId: 'health/health', nav: false , authorize: ["User", "Administrator"] },
        { route: 'oils', title: 'Oils', moduleId: 'oil/oils', nav: true , authorize: ["User", "Administrator"] },
        { route: 'oil/:id', title: 'Oil Detail', moduleId: 'oil/oil', nav: false , authorize: ["User", "Administrator"] },
        { route: 'users', title: 'Users', moduleId: 'user/users', nav: true , authorize: ["User", "Administrator"] },
        { route: 'user/:id', title: 'User Detail', moduleId: 'user/user', nav: false, authorize: ["User", "Administrator"] },

        // Account Controller urls
        { route: 'account/login',                         moduleId: 'account/login',                     title: 'Login',                       nav: false, hash : "#account/login" },
        { route: 'account/externalloginconfirmation',     moduleId: 'account/externalloginconfirmation', title: 'External login confirmation', nav: false, hash : "#account/externalloginconfirmation" },
        { route: 'account/externalloginfailure',          moduleId: 'account/externalloginfailure',      title: 'External login failure',      nav: false, hash : "#account/externalloginfailure" },
        { route: 'account/register',                      moduleId: 'account/register',                  title: 'Register',                    nav: false, hash : "#account/register" },
        { route: 'account/manage',                        moduleId: 'account/manage',                    title: 'Manage account',              nav: false, hash:  "#account/manage", authorize: ["User", "Administrator"] },
        { route: 'account/registrationcomplete',          moduleId: 'account/registrationcomplete',      title: 'Registration complete',       nav: false, hash:  "#account/registrationcomplete" },
        { route: 'account/forgotpassword',                moduleId: 'account/forgotpassword',            title: 'Forgot password',             nav: false, hash:  "#account/forgotpassword" },
        { route: 'account/resetpassword',                 moduleId: 'account/resetpassword',             title: 'Reset password',              nav: false, hash:  "#account/resetpassword" }

//        {
//            url: 'sessiondetail/:id',
//            moduleId: 'viewmodels/sessiondetail',
//            name: 'Edit Session',
//            visible: false
//        },{
//            url: 'sessionadd',
//            moduleId: 'viewmodels/sessionadd',
//            name: 'Add Session',
//            visible: false,
//            caption: '<i class="icon-plus"></i> Add Session',
//            settings: { admin: true }
//        }
    ];
    //{ url: 'sessionadd', moduleId: 'viewmodels/sessionadd', name: 'Add Session', visible: true, caption: '<i class="icon-plus"></i> Add Session' }
    
    var startModule = 'health';

    return {
        version: '1.1.0',
        appSubtitle: "[Ruby Jumpstart - Hot Towel]",
        debugEnabled: ko.observable(true),
        imageSettings: imageSettings,
        remoteServiceName: remoteServiceName,
        routes: routes,
        startModule: startModule,
        storage: storage,
        authenticate: {
            loginUrl:      'http://localhost/live/demo.smartexts.com/SPA/Backend/index.php/authenticate',
            registerUrl:   'http://localhost/live/demo.smartexts.com/SPA/Backend/index.php/register',
            excludes:       ['authenticate', 'register', 'login', 'about-page']
        }
    };
});
